--  Für Nachvollziehbarkeit der F3-Funktion Kurzname ersetzen. F3-Funktion macht Insert, damit man sieht, was wohin umbenannt wurde.
CREATE TABLE adkkrz_log(
  oldkrz varchar(21),
  newkrz varchar(21)
 );

CREATE TABLE laender(
  l_iso                 varchar(5) PRIMARY KEY,
  l_land                varchar(50),
  l_Wirtschaftsraum     varchar(5),
  l_embargo             boolean NOT null DEFAULT false,
  l_embargo_txt         text
 );


CREATE OR REPLACE FUNCTION laender__b_iu() RETURNS TRIGGER AS $$
   BEGIN
     new.l_Wirtschaftsraum := tsystem.landiso__zu_Wirtschaftsraum(new.l_iso);
     RETURN new;
  END $$ LANGUAGE plpgsql;

CREATE TRIGGER laender__b_iu
    BEFORE INSERT OR UPDATE OF l_iso
    ON laender
    FOR EACH ROW
    EXECUTE PROCEDURE laender__b_iu();


--Länderbezeichnungen in Fremdsprachen
CREATE TABLE laenderlang(
  ll_id        serial NOT NULL PRIMARY KEY,
  ll_iso       varchar(5) NOT NULL REFERENCES laender ON UPDATE CASCADE ON DELETE CASCADE,
  ll_spr_key   varchar(5) NOT NULL REFERENCES sprach,
  ll_land      varchar(50)
 );

CREATE OR REPLACE FUNCTION laender__a_iud() RETURNS TRIGGER AS $$
  BEGIN
    IF NOT tg_op='INSERT' THEN
      DELETE FROM laenderlang WHERE ll_iso=old.l_iso AND ll_spr_key=prodat_languages.current_lang();
    END IF;
    IF NOT tg_op='DELETE' THEN
      INSERT INTO laenderlang (ll_iso, ll_spr_key, ll_land) VALUES (new.l_iso, prodat_languages.current_lang(), new.l_land);
    END IF;
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER laender__a_iud
    AFTER INSERT OR UPDATE OR DELETE
    ON laender
    FOR EACH ROW
    EXECUTE PROCEDURE laender__a_iud();

--


CREATE TABLE ktovz
 (kto_name              varchar(100) NOT NULL PRIMARY KEY,
  kto_bknr              varchar(50),           --Kontonummer
  kto_blz               varchar(30),           --Bankleitzahl
  kto_bank              varchar(60) NOT NULL,           --Name der Bank
  kto_bic               varchar(50),                    --BIC
  kto_iban              varchar(50),                    --IBAN
  kto_qr_iban           varchar(50),                    --QR-IBAN nur CH, LI https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Zahlschein_(Einzahlungsschein)
  kto_pckonto           varchar(50),                    --Schweiz: für Zahlungsschein eine Postcode-KontoNr
  kto_std               boolean NOT NULL DEFAULT False,    --Standardkonto-Auswahl
  kto_bb                varchar(75)                     -- Hintergrund BriefBogen (FileName)
 );

--Adressstamm

-- Standard-Zahlungskonditionen und -Versandart (E=Einkauf und V=Verkauf)
CREATE OR REPLACE FUNCTION TAdk.StandardZak(status varchar(5), OUT zak integer, OUT skv integer, OUT sks numeric, OUT vers varchar(50)) RETURNS RECORD AS $$
 DECLARE
  found boolean;
 BEGIN
  SELECT true, azb_zlg, azb_skonto, azb_proz INTO found, zak, skv, sks FROM addison_zahlb WHERE azb_adk_def = status OR azb_adk_def = 'EV';
  IF found IS NULL THEN
    zak := IfThen(Status = 'V', 30, NULL);
    skv := 0;
    sks := 0;
  END IF;
  SELECT v_art INTO vers FROM versart WHERE v_adk_def = status OR v_adk_def = 'EV';
 END $$ LANGUAGE plpgsql;
--

--- Liefert PersonFunktionBezeichnung von sf_id
CREATE OR REPLACE FUNCTION TAdk.AP_SysFun(IN _sf_id integer, OUT sf_id integer,  OUT sf_bez varchar) RETURNS RECORD AS $$
 BEGIN
   SELECT sfd.sf_id, sfd.sf_bez INTO sf_id, sf_bez FROM TAdk.AP_SysFun_Defaults() AS sfd WHERE sfd.sf_id = _sf_id;
 END $$ LANGUAGE plpgsql STABLE;

--- Liefert Dokumentversandbezeuchnung von ad_dokversand
CREATE OR REPLACE FUNCTION TAdk.DokVersandTyp(IN _ad_dokversand integer, OUT ad_dokversand integer,  OUT ad_DokVersandBez varchar) RETURNS RECORD AS $$
 BEGIN
   SELECT dvtd.ad_dokversand, dvtd.ad_DokVersandBez INTO ad_dokversand, ad_DokVersandBez FROM TAdk.DokVersandTypen_Defaults() AS dvtd WHERE dvtd.ad_dokversand = _ad_dokversand;
 END $$ LANGUAGE plpgsql STABLE;

CREATE TABLE adk(
  ad_krz                varchar(21) NOT NULL CONSTRAINT xtt4052 PRIMARY KEY CONSTRAINT xtt16538__ad_krz CHECK (strpos(ad_krz, '%') = 0),
  ad_intnummer          varchar(21),--Interessentennummer
  ad_such               varchar(75),--Suchbezeichnung/Matchcode
  ad_fa1                varchar(100),--Firmenbezeichnung 1
  ad_fa2                varchar(100),--Firmenbezeichnung 2
  ad_adrzus             varchar(100),--adresszzsatz, zB Hinterhaus, ...
  ad_anr                varchar(50),-- Anrede
  ad_name               varchar(50),-- Name/Nachname
  ad_titel              varchar(50), --war ad_fun, jetzt Titel (Dr. etc.)
  ad_fun                varchar(200), --Funktion im Unternehmen
  ad_vorn               varchar(27),-- Vorname
  ad_str                varchar(75),-- Staße
  ad_pfc                varchar(17),-- Postfach
  ad_plz                varchar(30),-- Postleitzahl
  ad_ort                varchar(50),-- Ort
  ad_landiso            varchar(5) REFERENCES laender ON UPDATE CASCADE DEFAULT TSystem.Settings__Get('ad_landisovorgabe'),
  ad_land               varchar(50) DEFAULT prodat_languages.lang_land(TSystem.Settings__Get('ad_landisovorgabe')),
  ad_tel1               varchar(50),-- Telefon
  ad_telint             varchar(50),-- Telefon geschäflich intern
  ad_tel2               varchar(50),-- Telefon privat
  ad_mobil              varchar(50),-- Mobiltelefon
  ad_mobilpriv          varchar(50),-- Mobiltelefon privat
  ad_fax                varchar(50),-- Fax
  ad_faxpriv            varchar(50),-- Fax privat
  ad_email1             varchar(50),
  ad_email2             varchar(50),
  ad_stat               varchar(12),
  ad_bem                varchar(60),
  ad_vpber              integer DEFAULT 1 CONSTRAINT xtt4088 CHECK (ad_vpber>0),/*Kundenklasse*/
  ad_ustidnr            varchar(20), -- Umsatzsteuer-ID
  ad_steunr             varchar(30), -- Steuernummer
  ad_allg1              varchar(50),
  ad_allg2              varchar(50),
  ad_allg3              varchar(50),
  ad_allg4              varchar(50),
  ad_nexar_id           integer,     -- Lieferanten-ID von Nexar API
  ad_user_capt          varchar(100),
  --ad_vers             varchar(50),
  ad_vt                 integer,/*Vertreternummer*/
  ad_home               varchar(50),    --Homepage/Webpräsenz
  ad_gebu               date,
  ad_wirtsek            varchar(50),--wirtschaftssektor
  ad_branche            varchar(50),
  ad_info               text,
  ad_info_rtf           text,
  ad_ldauer             integer,        --Lieferdauer in Tagen
  ad_auslauf            date,
  ad_ersatzadkrz        varchar(21),
  ad_lgps               numeric (9,6), -- GPS Dezimalgrad Länge
  ad_bgps               numeric (9,6),  -- GPS Dezimalgrad Breite
  ad_eori               varchar(50), --EORI Nummer (Economic Operators’ Registration and Identification) ist der Nachfolger der Zollnummer auf europäischer Ebene
  --- #8670 Dokumentenversand Liste-Erweiterung -> TAdk.DokVersandTypen_Defaults()
  ad_dokversand         integer DEFAULT 1 CONSTRAINT xtt29140 CHECK((ad_dokversand IS NULL) OR ((TAdk.DokVersandTyp(ad_dokversand)).ad_dokversand IS NOT NULL)),
  -- System (tables__generate_missing_fields)
  dbrid                 varchar(32) NOT NULL DEFAULT nextval('db_id_seq'),
  insert_date           date,           --Die muessen hier schon erzeugt werden, weil die sonst nicht vererbt werden.
  insert_by             varchar(32),
  modified_by           varchar(32),
  modified_date         TIMESTAMP(0)
 );


  -- Trigger VORDEFFINIERT -> entsprechend automatischem DBRID-Trigger "{table}_set_modified" für table_modified()
  CREATE TRIGGER adk_set_modified
   BEFORE INSERT OR UPDATE
   ON adk
   FOR EACH ROW
   EXECUTE PROCEDURE table_modified();


 CREATE INDEX adk_ad_krz_like ON adk(ad_krz varchar_pattern_ops);

 --CREATE UNIQUE INDEX adk_adresses_ada_pos ON adk_adresses (ada_ad_krz, ada_pos)
 CREATE OR REPLACE FUNCTION adk__b_i() RETURNS TRIGGER AS $$
    BEGIN
    --Prüfung für Leerzeichen
       new.ad_krz = TRIM(both ' ' FROM new.ad_krz);
     RETURN new;
    END $$ LANGUAGE plpgsql;

    CREATE TRIGGER adk__b_i
    BEFORE INSERT
    ON adk
    FOR EACH ROW
    EXECUTE PROCEDURE adk__b_i();


 CREATE OR REPLACE FUNCTION adk__b_iu_adresschange() RETURNS TRIGGER AS $$
   DECLARE r RECORD;
   BEGIN
    IF TSystem.Settings__GetBool('AdresseChangedByPersonal') THEN --Wenn Trigger nicht 'ausgeschaltet' wird, kommt es zu Konflikten mit personal__a_iu_adresschange
          RETURN new;
    END IF;
    SELECT pers_krz,pers_str, pers_plz, pers_ort, pers_landiso, pers_land, IFTHEN(pers_tel2_f, pers_tel2, NULL) AS pers_tel2, pers_tel2_f, IFTHEN(pers_mobilpriv_f, pers_mobilpriv, NULL) AS pers_mobilpriv, pers_mobilpriv_f, pers_faxpriv, pers_email2 INTO r FROM personal WHERE new.ad_krz=pers_krz;
    IF (r.pers_krz IS NOT NULL)
         AND
                     (      coalesce(new.ad_str,'') <> coalesce(r.pers_str,'') OR
                            coalesce(new.ad_plz,'') <> coalesce(r.pers_plz,'') OR
                            coalesce(new.ad_ort,'') <> coalesce(r.pers_ort,'') OR
                            coalesce(new.ad_landiso,'') <> coalesce(r.pers_landiso,'') OR
                            coalesce(new.ad_land,'') <> coalesce(r.pers_land,'') OR
                            coalesce(new.ad_tel2,'') <> coalesce(r.pers_tel2,'') OR
                            coalesce(new.ad_mobilpriv,'') <> coalesce(r.pers_mobilpriv,'') OR
                            coalesce(new.ad_faxpriv,'') <> coalesce(r.pers_faxpriv,'') OR
                            coalesce(new.ad_email2,'') <> coalesce(r.pers_email2,'')
                 ) THEN
         RAISE EXCEPTION '%', Format(lang_text(29169) /*'Personaldaten dürfen nur im Personalmodul geändert werden'*/);
    END IF;
    --
   RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER adk__b_iu_adresschange
    BEFORE INSERT OR UPDATE OF ad_str, ad_plz, ad_ort, ad_landiso, ad_land, ad_tel2, ad_mobilpriv, ad_faxpriv, ad_email2
    ON adk
    FOR EACH ROW
    EXECUTE PROCEDURE adk__b_iu_adresschange();

    --- #9675
  CREATE OR REPLACE FUNCTION adk__a__u_ad_landiso() RETURNS TRIGGER AS $$
   BEGIN
    IF new.ad_landiso <> old.ad_landiso THEN
       PERFORM TSystem.adk1__update__a1_euexport__a1_export(new.ad_krz);
    END IF;
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER adk__a__u_ad_landiso
    AFTER UPDATE
    OF ad_landiso
    ON adk
    FOR EACH ROW
    EXECUTE PROCEDURE adk__a__u_ad_landiso();

 --
CREATE TABLE adklog
 (adkl_id               serial PRIMARY KEY,
  adkl_time             TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT currenttime(), --zeitpunkt (insert und modified date haben nur datum, keine uhrzeit)
  adkl_ad_krz           varchar(21) REFERENCES adk ON UPDATE CASCADE ON DELETE CASCADE, --Kürzel
  --adkl_ad_krz_new        varchar(21),     --Kürzel  neu
  adkl_ad_fa1_old       varchar(100),    --Firmenname alt
  adkl_ad_fa1_new       varchar(100),    --Firmenname neu
  adkl_ad_name_old      varchar(50),    --Person-Nachname alt
  adkl_ad_name_new      varchar(50),    --Person-Nachname neu
  adkl_ad_vorn_old      varchar(27),    --Person-Vorname alt
  adkl_ad_vorn_new      varchar(27),    --Person-Vorname neu
  adkl_ad_str_old       varchar(75),    --Straße alt
  adkl_ad_str_new       varchar(75),    --Straße neu
  adkl_ad_plz_old       varchar(30),    --PLZ alt
  adkl_ad_plz_new       varchar(30),    --PLZ neu
  adkl_ad_ort_old       varchar(50),    --Ort alt
  adkl_ad_ort_new       varchar(50)    --Ort neu
 );
--

-- abweichende Liefer- und Rechnungadressen
CREATE TABLE adk_adresses (
  ada_id                serial PRIMARY KEY,
  ada_ad_krz            varchar(21) NOT NULL REFERENCES adk ON UPDATE CASCADE ON DELETE CASCADE,
  ada_pos               integer NOT NULL,
  ada_krzl              varchar(25) UNIQUE NOT NULL,  -- länger als adresskrzl da ~L-1 usw.
  ada_ladress           boolean NOT NULL DEFAULT true,   -- Zusatzadresse ist eine Lieferadresse
  ada_radress           boolean NOT NULL DEFAULT false,  -- Zusatzadresse ist eine Rechnungsadresse
  ada_vorgabe           boolean NOT NULL DEFAULT false,  -- Adresse wird automatisch gezogen
  ada_fa1               varchar(100),
  ada_fa2               varchar(100),
  ada_adrzus            varchar(100),
  ada_name              varchar(50),
  ada_vorn              varchar(75),
  ada_pfc               varchar(17),
  ada_str               varchar(75),
  ada_plz               varchar(30),
  ada_ort               varchar(50),
  ada_landiso           varchar(5) REFERENCES laender ON UPDATE CASCADE,
  ada_land              varchar(50),
  ada_lgps              numeric(9,6),   -- GPS Dezimalgrad Länge
  ada_bgps              numeric(9,6),   -- GPS Dezimalgrad Breite
  ada_ldauer            integer,        -- Lieferdauer Tor/Kunde
  ada_auslauf           date,
  -- System (tables__generate_missing_fields)
  dbrid                 varchar(32) NOT NULL DEFAULT nextval('db_id_seq')
);

-- Indizes
    CREATE INDEX adk_adresses_ada_ad_krz ON adk_adresses(ada_ad_krz);

    CREATE UNIQUE INDEX adk_adresses_ada_vorgabe_l ON adk_adresses(ada_ad_krz, ada_ladress, ada_vorgabe) WHERE ada_vorgabe;
    CREATE UNIQUE INDEX adk_adresses_ada_vorgabe_f ON adk_adresses(ada_ad_krz, ada_radress, ada_vorgabe) WHERE ada_vorgabe;

    -- CREATE UNIQUE INDEX adk_adresses_ada_pos ON adk_adresses (ada_ad_krz, ada_pos)
--

-- Position und Kürzel (aus Pos) vergeben, wenn NULL
CREATE OR REPLACE FUNCTION adk_adresses__b_iu() RETURNS TRIGGER AS $$
  BEGIN
    IF new.ada_pos IS NULL THEN
        IF new.ada_ladress THEN
            new.ada_pos:= (SELECT max(ada_pos) FROM adk_adresses WHERE ada_ad_krz = new.ada_ad_krz AND ada_ladress) + 1;
        ELSE
            new.ada_pos:= (SELECT max(ada_pos) FROM adk_adresses WHERE ada_ad_krz = new.ada_ad_krz AND ada_radress) + 1;
        END IF;

        new.ada_pos:= coalesce(new.ada_pos, 1);
    END IF;

    IF new.ada_krzl IS NULL OR new.ada_krzl = new.ada_ad_krz THEN
        IF length(new.ada_ad_krz || '~' || IFTHEN(new.ada_ladress, 'L-', 'F-') || new.ada_pos) > 25 THEN
            /* #8763
                RAISE EXCEPTION USING MESSAGE = 'Der Kurzname der Liefer-/Rechnungsadresse
                (' || new.ada_ad_krz || '~' || IFTHEN(new.ada_ladress, 'L-', 'F-') | |new.ada_pos || ')
                ist zu lang.
                Maximale Länge: 25 Zeichen.
                Aktuelle Länge: ' || length(new.ada_ad_krz || '~' || IFTHEN(new.ada_ladress, 'L-', 'F-') || new.ada_pos) || ' Zeichen.';
            */

            RAISE EXCEPTION USING MESSAGE = Format(lang_text(29170), new.ada_ad_krz || '~' || IFTHEN(new.ada_ladress, 'L-', 'F-') || new.ada_pos, length(new.ada_ad_krz || '~' || IFTHEN(new.ada_ladress, 'L-', 'F-') || new.ada_pos));
        END IF;

        new.ada_krzl:= new.ada_ad_krz || '~' || IFTHEN(new.ada_ladress, 'L-', 'F-') || new.ada_pos;
    END IF;

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER adk_adresses__b_iu
    BEFORE INSERT OR UPDATE
    ON adk_adresses
    FOR EACH ROW
    EXECUTE PROCEDURE adk_adresses__b_iu();

--
CREATE OR REPLACE FUNCTION TSystem.views__Adressen__drop() RETURNS VOID AS $$
    BEGIN

      DROP VIEW IF EXISTS adressen_view CASCADE;  --CASCADE wegen SUN_EDB_VIEW

      -- Prüfen, ob die Funktion schon da ist.
      IF  EXISTS(SELECT true from pg_proc where proname = 'dropprojectviews') THEN
          PERFORM DropProjectViews();
      END IF;

    END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION TSystem.views__Adressen__recreate() RETURNS VOID AS $$
    BEGIN
    --modified_date fuer abacus-schnittstelle notwendig
    CREATE OR REPLACE VIEW adressen_view AS
      SELECT
        dbrid,
        ad_krz AS adk_ad_krz,
        ad_krz,
        ad_fa1,
        ad_fa2,
        ad_adrzus,
        ad_anr,
        ad_titel,
        ad_name,
        ad_vorn,
        ad_str,
        ad_plz,
        ad_ort,
        ad_landiso::varchar(5),
        ad_land,
        ad_ldauer,
        ad_pfc,
        ad_fax,
        ad_tel1,
        ad_tel2,
        ad_email1,
        ad_email2,
        ad_such,
        ad_ustidnr,
        ad_branche,
        ad_stat,
        ad_bem,
        adk.modified_date,
        ad_lgps,
        ad_bgps,
        ad_auslauf,
        ad_eori
      FROM adk

      UNION
      SELECT
        adk_adresses.dbrid,
        ada_ad_krz,
        ada_krzl,
        coalesce( ada_fa1, ad_fa1 ),
        NULL,
        ada_adrzus,
        NULL,
        NULL,
        coalesce( ada_name, ad_name ),
        coalesce( ada_vorn, ad_vorn ),
        coalesce( ada_str, ad_str ),
        coalesce( ada_plz, ad_plz ),
        coalesce( ada_ort, ad_ort ),
        coalesce( ada_landiso::varchar(5), ad_landiso ),
        coalesce( ada_land, ad_land ),
        coalesce( ada_ldauer, ad_ldauer ),
        ada_pfc,
        ad_fax,
        ad_tel1,
        ad_tel2,
        ad_email1,
        ad_email2,
        ad_such,
        ad_ustidnr,
        ad_branche,
        ad_stat,
        ad_bem,
        adk.modified_date,
        ada_lgps,
        ada_bgps,
        coalesce( ada_auslauf, ad_auslauf ),
        ad_eori
      FROM adk_adresses
      JOIN adk ON adk.ad_krz = ada_ad_krz;

      --Notwendig wegen DB Neu erstellen, da gibt es die Funktion und View noch nicht.
      IF  EXISTS(SELECT true from pg_proc where proname = 'views__project__create') THEN
        PERFORM TSystem.views__project__create();
      END IF;

    END $$ LANGUAGE plpgsql;

SELECT TSystem.views__Adressen__recreate();



CREATE TABLE adressen_keys
 (ak_krz        varchar(30) PRIMARY KEY,
  ak_ad_krz     varchar(21) REFERENCES adk ON UPDATE CASCADE ON DELETE CASCADE
 );

CREATE INDEX adressen_keys_ak_ad_krz ON adressen_keys(ak_ad_krz);


--um Foreign Key weiter auf DB-Ebene zu halten müssen wir eine neue Tabelle einführen die alle Kürzel aus Liefer und Rechnungsadresse führt. Die gesamten Tabellen referenzieren dann dort hin
 CREATE OR REPLACE FUNCTION adk__a_iud() RETURNS TRIGGER AS $$
    BEGIN
     IF tg_op='DELETE' THEN
            DELETE FROM adressen_keys WHERE ak_krz=old.ad_krz;
            RETURN old;
     ELSIF tg_op='UPDATE' THEN
            IF new.ad_krz<>old.ad_krz THEN
                    UPDATE adressen_keys SET ak_krz=new.ad_krz, ak_ad_krz=new.ad_krz WHERE ak_krz=old.ad_krz;
            END IF;
            RETURN new;
     ELSE
            INSERT INTO adressen_keys(ak_krz, ak_ad_krz) VALUES (new.ad_krz, new.ad_krz);
            RETURN new;
     END IF;
    END $$ LANGUAGE plpgsql;

    CREATE TRIGGER adk__a_iud
     AFTER INSERT OR UPDATE OR DELETE
     ON adk
     FOR EACH ROW
     EXECUTE PROCEDURE adk__a_iud();

 --AdressKeywordSearch
 CREATE OR REPLACE FUNCTION adk__a_iu_keywordsearch() RETURNS TRIGGER AS $$
     BEGIN
      PERFORM TSystem.kws_create_keywords(new.*);
      RETURN new;
     END $$ LANGUAGE plpgsql;

     CREATE TRIGGER adk__a_iu_keywordsearch
      AFTER INSERT OR UPDATE
      ON adk
      FOR EACH ROW
      EXECUTE PROCEDURE adk__a_iu_keywordsearch();

 --um Foreign Key weiter auf DB-Ebene zu halten müssen wir eine neue Tabelle einführen die alle Kürzel aus Liefer und Rechnungsadresse führt. Die gesamten Tabellen referenzieren dann dort hin
 CREATE OR REPLACE FUNCTION adk_adresses__a_iud() RETURNS TRIGGER AS $$
    BEGIN
     IF tg_op='DELETE' THEN
            DELETE FROM adressen_keys WHERE ak_krz=old.ada_krzl;
            RETURN old;
     ELSIF tg_op='UPDATE' THEN
            IF new.ada_krzl<>old.ada_krzl THEN
            UPDATE adressen_keys SET ak_krz=new.ada_krzl WHERE ak_krz=old.ada_krzl;
            END IF;
            RETURN new;
     ELSE
            INSERT INTO adressen_keys(ak_krz, ak_ad_krz) VALUES (new.ada_krzl, new.ada_ad_krz);
            RETURN new;
     END IF;
    END $$ LANGUAGE plpgsql;

    CREATE TRIGGER adk_adresses__a_iud
     AFTER INSERT OR UPDATE OR DELETE
     ON adk_adresses
     FOR EACH ROW
     EXECUTE PROCEDURE adk_adresses__a_iud();



-- Status einer Adresse (adk oder adressen_view) ermitteln. Prüft mittels übergebenem Auslaufdatum - benötigt kein SubSelect, als SQL Funktion angelegt damit Inlining funktioniert.
CREATE OR REPLACE FUNCTION GetAdressStatus(IN adauslauf date, OUT adkstatus varchar(30), OUT cimgreen boolean,OUT cimyellow boolean,OUT cimred boolean) RETURNS RECORD AS $$
   SELECT
      Trim(TSystem.IfThen(gueltig,'G ','') || TSystem.IfThen(auslauf,'AU ','') || TSystem.IfThen(ungueltig,'UN ','')) AS adkstatus,
      FALSE     AS CimGreen ,
      Auslauf   AS CimYellow,
      ungueltig AS CimRed
   FROM
    ( SELECT
        (coalesce(adauslauf, current_date) > current_date)      AS auslauf,
        (adauslauf IS NOT NULL AND (adauslauf <= current_date)) AS ungueltig,
        (adauslauf IS NULL)                                     AS gueltig
    ) AS status
 $$ LANGUAGE SQL STABLE ;
--

-- Status einer Adresse (adk oder adressen_view) ermitteln. Führt SubSelect auf adressen_view aus um Auslaufdatum zu ermitteln.
CREATE OR REPLACE FUNCTION GetAdressStatus(IN adkrz varchar, OUT adkstatus varchar(30), OUT cimgreen boolean,OUT cimyellow boolean,OUT cimred boolean) RETURNS RECORD AS $$
  SELECT AdkStatus, CimGreen, CimYellow, CimRed
  FROM adressen_view
   join lateral GetAdressStatus(ad_auslauf) on true
  WHERE ad_krz = adkrz;
 $$ LANGUAGE sql STABLE;
--

CREATE TABLE kstatus
 (kstatus               varchar(12) NOT NULL PRIMARY KEY,
  bezeich               varchar(50)
 );

/* Status A darf nicht verändert werden, weil in den Assistenten verwendet */
 CREATE OR REPLACE FUNCTION kstatus__a_du() RETURNS TRIGGER AS $$
  BEGIN
   RAISE EXCEPTION 'xtt15925';
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER kstatus__a_du
   BEFORE DELETE OR UPDATE
   OF kstatus
   ON kstatus
   FOR EACH ROW
   WHEN (old.kstatus IN ('A'))
   EXECUTE PROCEDURE kstatus__a_du();


CREATE TABLE adkbewarab
 (adwarab_id             serial PRIMARY KEY,
  adwarab_ad_krz         varchar(21)  REFERENCES adk ON UPDATE CASCADE ON DELETE CASCADE,
  adwarab_ad_vpber       integer,
  adwarab_waco           varchar(3)   NOT NULL REFERENCES bewa,
  adwarab_kurs_ab        numeric(7,4) NOT NULL,
  adwarab_kurs_bis       numeric(7,4) NOT NULL,
  adwarab_rab            numeric(5,2) NOT NULL,
  adwarab_auslauf        date
 );



/*Ansprechpartner*/

CREATE TABLE adkap (
  ap_id                 serial PRIMARY KEY,
  ap_ad_krz             varchar(21) NOT NULL REFERENCES adk ON UPDATE CASCADE ON DELETE CASCADE,
  ap_krzl               varchar(10),
  ap_name               varchar(50) NOT NULL,   -- Nachname
  ap_vorn               varchar(30),    -- Vorname
  ap_sex_man            boolean,
  ap_fun                varchar(50),    -- Funktion im Unternehmen
  ap_anr                varchar(20),    -- Anrede
  ap_titel              varchar(50),    -- Titel
  ap_tel                varchar(40),    -- Telefonnr. Fest
  ap_fax                varchar(40),    -- Faxnummer
  ap_mobil              varchar(40),    -- Handynummer
  ap_mail               varchar(100),    -- Email-Adresse
  ap_gebu               date,           -- Geburtstag
  ap_text               text,           -- Freies Memo für text
  ap_text_rtf           text,
  ap_allg1              varchar(50),    -- Freie Textfelder
  ap_allg2              varchar(50),
  ap_allg3              varchar(50),
  ap_auslauf            date, --ausgelaufener Kontakt
  --- #8670 Ansprechpartnerfunktionalität. Liste-Erweiterung -> TAdk.AP_SysFun_Defaults()
  ap_sysfun             integer CONSTRAINT xtt29136 CHECK( (ap_sysfun IS NULL) OR ( (TAdk.AP_SysFun(ap_sysfun)).sf_id IS NOT NULL) )
);

CREATE UNIQUE INDEX adkap__ap_ad_krz__ap_krzl ON adkap (ap_ad_krz, ap_krzl) WHERE ap_krzl IS NOT NULL;

-- Verschlagwortung Adresssuche
CREATE OR REPLACE FUNCTION adkap__a_iud_keywordsearch() RETURNS TRIGGER AS $$
  DECLARE krz varchar;
  BEGIN
    IF tg_op = 'DELETE' THEN
       krz:= old.ap_ad_krz;
    ELSE
       krz:= new.ap_ad_krz;
    END IF;

    PERFORM TSystem.kws_create_keywords(adk) FROM adk WHERE ad_krz = krz;

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER adkap__a_iud_keywordsearch
    AFTER INSERT OR UPDATE OR DELETE
    ON adkap
    FOR EACH ROW
    EXECUTE PROCEDURE adkap__a_iud_keywordsearch();
--

-- Vergibt Kürzel Ansprechpartner falls noch keines angegeben wurde.
CREATE OR REPLACE FUNCTION adkap__b_iu() RETURNS TRIGGER AS $$
  BEGIN
    IF coalesce(new.ap_krzl, '') = '' THEN
        new.ap_krzl:= TAdk.CreateAPKrzl(new.ap_ad_krz, new.ap_name, new.ap_vorn);

        IF new.ap_krzl = '' THEN
            new.ap_krzl:= NULL;
        END IF;
    END IF;

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER adkap__b_iu
    BEFORE INSERT OR UPDATE
    ON adkap
    FOR EACH ROW
    EXECUTE PROCEDURE adkap__b_iu();
--

-- Zuständige Mitarbeiter für einen Kunden/Lieferanten
CREATE TABLE adkZust
(azust_id               serial PRIMARY KEY,
 azust_ad_krz           varchar(21) NOT NULL REFERENCES adk ON UPDATE CASCADE ON DELETE CASCADE,        -- Kürzel der Firma die von Mitarbeiter betreut wird
 azust_ll_db_usename    varchar(20) NOT NULL, --DB-Usename aus llv
 azust_text             text
);

CREATE UNIQUE INDEX adkZust_krz_llminr ON adkZust(azust_ad_krz, azust_ll_db_usename);

--IsMyAdress
CREATE OR REPLACE FUNCTION adkzust__ismine(krzl varchar) RETURNS varchar AS $$--gibt "current_user" zurück wenn der aktuell angemeldete Mitarbeiter für eine Adresse zuständig ist, ansonsten 0.
DECLARE iszust boolean;
BEGIN
 SELECT true INTO iszust FROM adkzust WHERE azust_ad_krz=krzl AND azust_ll_db_usename=current_user;
 IF coalesce(iszust, FALSE)
     --OR NOT EXISTS(SELECT true FROM adkzust WHERE azust_ll_minr=current_user)
    THEN
        RETURN 'mine';
 ELSE
        RETURN NULL;
 END IF;
END $$ LANGUAGE plpgsql STABLE;

CREATE TABLE zahlart
 (za_id                 serial PRIMARY KEY,     -- ID
  za_bez                varchar(50),            -- Bezeichnung
  za_buchcode           varchar(10)             -- Umcodierung für Buchhaltungssoftware
 );

CREATE TABLE zahlart_lang
 (zal_id                serial NOT NULL PRIMARY KEY,
  zal_za_id             integer NOT NULL REFERENCES zahlart ON UPDATE CASCADE ON DELETE CASCADE,
  zal_spr_key           varchar(5) NOT NULL CONSTRAINT xtt4089 REFERENCES sprach,
  zal_txt               varchar(50)
 );

CREATE OR REPLACE FUNCTION zahlart__a_iud() RETURNS TRIGGER AS $$
   BEGIN
    IF NOT tg_op='DELETE' THEN
     IF tg_op='UPDATE' THEN
       DELETE FROM zahlart_lang WHERE zal_za_id=old.za_id AND zal_spr_key=prodat_languages.current_lang();
       IF new.za_id<>old.za_id THEN
         DELETE FROM zahlart_lang WHERE zal_za_id=new.za_id AND zal_spr_key=prodat_languages.current_lang();
       END IF;
     END IF;
     INSERT INTO zahlart_lang (zal_za_id, zal_spr_key, zal_txt) VALUES (new.za_id, prodat_languages.current_lang(), new.za_bez);
    END IF;
    RETURN new;
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER zahlart__a_iud
    AFTER INSERT OR UPDATE OR DELETE
    ON zahlart
    FOR EACH ROW
    EXECUTE PROCEDURE zahlart__a_iud();

/* Vorgaben: Normen und Zertifikate */
CREATE TABLE pre_NormZertTyp
(pnzt_type              varchar(20) PRIMARY KEY,        -- Kurzname
 pnzt_bez               varchar(100) NOT NULL,           -- Typenbezeichnung
 pnzt_bez_sub    varchar (200)      -- Untergruppe des Typs
);

/* Vorgaben: Umfang der Zertifizierung */
CREATE TABLE pre_ZertUmfang
(pzu_descr              varchar(200) PRIMARY KEY,       -- Beschreibung, Umfang der Zertifizierung
 pzu_txt                text                            -- Hinweistext
);

/* Grundtabelle für qsnorm/normzert #5868 */
CREATE TABLE qsnorm_descr
(qsd_id         serial PRIMARY KEY,
 qsd_bez       varchar(100) NOT NULL  -- Kurzbeschreibung der Norm Loll
);

/* Normen und Zertifikate */
CREATE TABLE NormZert
(noz_id         serial PRIMARY KEY,
 noz_ad_krz     varchar(21) NOT NULL REFERENCES adk ON UPDATE CASCADE ON DELETE CASCADE,            -- Kürzel Lieferant/Kunde
 noz_isdeb      boolean NOT NULL,                                                                      -- für Debitor
 noz_iskred     boolean NOT NULL,                                                                      -- für Kreditor
 noz_qs_ident   varchar(50) NOT NULL, --REFERENCES qsnorm ON UPDATE CASCADE,                        -- Norm oder Zertifikat
 noz_descr      varchar(200),                                                                       -- Beschreibung, Umfang der Zertifizierung
 noz_freig      varchar(100),                                                                       -- Freigabe, analog früherem Zertifikat des Lieferanten
 noz_apint      varchar(10), -- REFERENCES llv(ll_db_usename) DEFAULT tsystem.current_user_ll_db_usename()  -- Ansprechpartner Intern...Standard angemeldeter Nutzer    ;
 noz_intv       integer,                                                                            -- Prüfintervall in Monaten
 noz_bdat       date,                                                                               -- Beginn der Gültigkeit
 noz_edat       date,                                                                               -- Ende/Ablauf der Gültigkeit
 noz_sdat       date,                                                                               -- Stand vom (eine Norm enthält das Datum ihrer letzten Änderung)
 noz_sperr      boolean NOT NULL DEFAULT FALSE,                                                        -- Sperrung nach Ablauf, wenn FALSE und abgelaufen, wird nur gewarnt aber nicht gesperrt.
 noz_txt        text,                                                                               -- Zusatztext
 noz_idx        varchar(30),                                                                        -- Index Änderungsstand
 noz_lgort      varchar(200),                                                                       -- Befindet sich wo, Angabe, wo sich dieses physische Dokument (Buch) befindet
 noz_allg1      varchar(100),                                                                       -- Allgemein 1
 noz_allg2      varchar(100),                                                                       -- Allgemein 2
 noz_edikz      varchar(1),
 noz_qs_txt     text,                                                                               -- Prüfergebnis
 CHECK(noz_isdeb <> noz_iskred)
);


CREATE UNIQUE INDEX noz_uniqueindex ON NormZert (noz_ad_krz, noz_qs_ident, coalesce(UPPER(noz_descr), ''), noz_isdeb, noz_iskred, noz_sdat, noz_allg1, noz_allg2);

/*-------------------------- Zahlungskonditionen --------------------------*/

-- ADDISON Zahlungsbedingungen
CREATE TABLE addison_zahlb (
  azb_id        integer PRIMARY KEY DEFAULT -1,
  azb_bez       varchar(40),
  azb_skonto    integer,     -- skv
  azb_proz      numeric,     -- sks
  azb_zlg       integer,     -- zak
  azb_adk_def   varchar(5)   -- als Vorgabe verwenden für E=Einkauf(adk2), V=Verkauf(adk1) oder EV=Einkauf+Verkauf
 );

--- Index
CREATE UNIQUE INDEX zahlb__unique ON addison_zahlb (azb_zlg, azb_skonto, azb_proz, upper(azb_adk_def) ); -- #19373
CREATE UNIQUE INDEX zahlb__one_default ON addison_zahlb (upper(azb_adk_def)) WHERE azb_adk_def IS NOT null;
--

----- ADDISON Zahlungsbedingungen. Übersetzungen #7348
CREATE TABLE addison_zahlbtxt                                                            -- #7348
 (azbl_id       serial NOT NULL PRIMARY KEY,
  azbl_azb_id   integer NOT NULL REFERENCES addison_zahlb ON DELETE CASCADE,
  azbl_spr_key  varchar(5) NOT NULL REFERENCES sprach,
  azbl_txt      varchar(80)
 );

--
CREATE OR REPLACE FUNCTION addison_zahlb__a_iud() RETURNS TRIGGER AS $$                  -- #7348
  BEGIN
    IF NOT tg_op='INSERT' THEN
        DELETE FROM addison_zahlbtxt WHERE azbl_azb_id=old.azb_id AND azbl_spr_key=prodat_languages.current_lang();
    END IF;
    IF NOT tg_op='DELETE' THEN
        INSERT INTO addison_zahlbtxt (azbl_azb_id, azbl_spr_key, azbl_txt) VALUES (new.azb_id, prodat_languages.current_lang(), new.azb_bez);
    END IF;
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER addison_zahlb__a_iud                                                    -- #7348
    AFTER INSERT OR UPDATE OR DELETE
    ON addison_zahlb
    FOR EACH ROW
    EXECUTE PROCEDURE addison_zahlb__a_iud();

--
CREATE OR REPLACE FUNCTION lang_addison_zahlb(integer, varchar) RETURNS varchar AS $$    -- #7348
 DECLARE result varchar;
 BEGIN
   SELECT coalesce(azbl_txt, azb_bez) INTO result
   FROM addison_zahlb
   LEFT JOIN addison_zahlbtxt ON azbl_azb_id = azb_id AND azbl_spr_key = $2
   WHERE azb_id = $1;
   RETURN result;
 END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION addison_zahlb__b_i() RETURNS TRIGGER AS $$
  BEGIN
      IF new.azb_id IS NULL OR new.azb_id = -1 THEN
         new.azb_id := max(azb_id) + 1 FROM addison_zahlb;
      END IF;
      RETURN new;
  END $$ LANGUAGE plpgsql;
    --
  CREATE TRIGGER addison_zahlb__b_i
    BEFORE INSERT
    ON addison_zahlb
    FOR EACH ROW
    EXECUTE PROCEDURE addison_zahlb__b_i();
--

/*------------------------------------------------------------------------*/
-- Kundendaten
CREATE TABLE adk1
 (a1_krz                       varchar(21) NOT NULL PRIMARY KEY REFERENCES adk ON UPDATE CASCADE ON DELETE CASCADE,
  a1_knr                       integer NOT NULL,
  a1_an1                       varchar(15),
  a1_krl                       numeric,
  a1_zak                       smallint NOT NULL DEFAULT (TAdk.StandardZak('V')).zak,
  a1_skv                       smallint NOT NULL DEFAULT (TAdk.StandardZak('V')).skv,
  a1_sks                       numeric NOT NULL DEFAULT (TAdk.StandardZak('V')).sks,
  a1_maco                      smallint,
  a1_spco                      smallint NOT NULL DEFAULT 0 REFERENCES adkspco ON UPDATE CASCADE,
  a1_veco                      varchar(10),
  a1_desk                      varchar(12),
  a1_zera                      numeric,
  a1_aprc                      smallint,
  a1_bcnr                      numeric,
  a1_wuco                      smallint DEFAULT TSystem.Settings__GetInteger('auftgsteucode', 3) REFERENCES steutxt,--umsatzsteuer 19%
  a1_dianeu                    smallint,
  a1_dialog                    smallint,
  a1_bknr                      varchar(50),  -- Veraltet? Was soll ich mit den Kontendaten meines Kunden? Aber ACHTUNG: # = eigene Bankdaten!
  a1_blz                       varchar(30),  -- Veraltet?
  a1_bank                      varchar(60),  -- Veraltet?
  a1_bic                       varchar(50),  -- Veraltet?
  a1_iban                      varchar(50),  -- Veraltet?
  a1_eknr                      varchar(50),
  a1_zahlart                   smallint REFERENCES zahlart ON UPDATE CASCADE,
  a1_allg1                     varchar(50),
  a1_allg2                     varchar(50),
  a1_cuz                       varchar(1),
  a1_waco                      varchar(3) NOT NULL DEFAULT TSystem.Settings__Get('BASIS_W') REFERENCES bewa,
  a1_euexport                  boolean DEFAULT FALSE,
  a1_export                    boolean DEFAULT FALSE,
  a1_ursprungstxt              boolean DEFAULT FALSE,
  a1_export_adktxt             text,         -- überschriebene Exporttexte spezifisch für Adresse
  a1_export_adktxt_rtf         text,         -- überschriebene Exporttexte spezifisch für Adresse
  a1_ursprungstxt_adktxt       text,         --  ~~~~
  a1_ursprungstxt_adktxt_rtf   text,         --  ~~~~
  a1_norm                      varchar(50),
  a1_vers                      varchar(50) DEFAULT (TAdk.StandardZak('V')).vers,       --Versandart
  a1_tolfrueh                  integer,      --Toleranz in Tagen bei Abweichung vom Lieferdatum (Zu früh)
  a1_tolspaet                  integer,      --Toleranz in Tagen bei Abweichung vom Lieferdatum (Zu spät)
  a1_toltermbezug              boolean DEFAULT TRUE, -- Toleranzbewertung bezüglich zuletzt bestätigtem Liefertermin des Auftrags
  a1_toltext                   text,           --Ergänzungstext zu Lieferkonditionen
  a1_ktv_name                  varchar(100) REFERENCES ktovz ON UPDATE CASCADE, -- Kontoverzeichhnis
  a1_zaz                       varchar(50),  -- Zentralisiertes Abrechnungsverfahren der Zollverwaltung

  -- Leitweg-ID für XRechnungen
  -- Formatierung siehe https://www.xoev.de/xrechnung-16828#LID
  --   Grobadressierung: 2 bis 12 Ziffern
  --   Feinadressierung (optional): ein Bindestrich, gefolgt von 1 bis 30 alphanumerischen Zeichen
  --   Prüfziffer: ein Bindestrich, gefolgt von 2 Prüfziffern
  a1_leitweg_id                varchar(46) CONSTRAINT xtt28884 CHECK ( a1_leitweg_id ~ '^[0-9]{2,12}(-[0-9a-zA-Z]{1,30})?-[0-9]{2}$' ),
  a1_sperr_auftg               boolean NOT null DEFAULT false
 );

CREATE INDEX adk1_a1_knr ON adk1 (a1_knr);

 --
 CREATE OR REPLACE FUNCTION adk1__b_10_iu__a1_knr() RETURNS TRIGGER AS $$
  DECLARE
      -- Systemvorgaben
      -- Setting: Adressverwaltung / Debitoren von bzw. bis
      _min                  integer := TSystem.Settings__GetInteger( 'debi_von' );
      _max                  integer := TSystem.Settings__GetInteger( 'debi_bis' );
      -- Setting: Adressverwaltung / "Debitorennummer kann mehrfach vorkommen" ist nicht gesetzt.
      _check_a1_knr_unique  boolean := NOT TSystem.Settings__GetBool( 'unique_a1_knr' );
  BEGIN
    -- Beachte:
      -- Negative Debitorennummern sind zur initialen Anlage immer erlaubt.
      -- WHEN ( new.a1_knr > 0 )


    -- Prüfung des vorgebenen Bereichs der Debitorennummern
    IF
            _min > 0
        AND _max > 0
        AND new.a1_knr NOT BETWEEN _min AND _max
    THEN

        RAISE EXCEPTION
            'xtt6239 - number (%) violates min (%) or max (%) of debinummerkreis',
            new.a1_knr,
            _min,
            _max
        ;

    END IF;


    -- Prüfung auf doppelte Debitorennummern
    IF
        -- gemäß Einstellung erforderlich
            _check_a1_knr_unique
        -- Es gibt gleiche Debitorennummer an anderer Adresse.
        AND EXISTS(
              SELECT true
              FROM adk1
              WHERE a1_knr = new.a1_knr
                AND a1_krz <> new.a1_krz
            )
    THEN

        RAISE EXCEPTION 'duplicate key violates unique constraint "adk1_a1_knr"';

    END IF;


    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER adk1__b_10_iu__a1_knr
    BEFORE INSERT OR UPDATE
    OF a1_knr
    ON adk1
    FOR EACH ROW
    -- Negative Debitorennummern sind zur initialen Anlage immer erlaubt.
    WHEN ( new.a1_knr > 0 )
    EXECUTE PROCEDURE adk1__b_10_iu__a1_knr();
 --

 --
 CREATE OR REPLACE FUNCTION adk1__b_20_iu() RETURNS TRIGGER AS $$
  BEGIN

    -- Vorgaben bei Export-text setzen
    IF new.a1_export_adktxt IS NOT NULL THEN

        new.a1_export   := true;
        new.a1_euexport := false;

    END IF;


    -- Vorgabe bei text für Ursprungserklärung setzen
    IF new.a1_ursprungstxt_adktxt IS NOT NULL THEN

        new.a1_ursprungstxt := true;

    END IF;


    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER adk1__b_20_iu
    BEFORE INSERT OR UPDATE
    ON adk1
    FOR EACH ROW
    EXECUTE PROCEDURE adk1__b_20_iu();
 --

 -- Daten aus Personal ziehen, wenn Debitor angelegt wird
 CREATE OR REPLACE FUNCTION adk1__a_i__datenAusPersonal() RETURNS TRIGGER AS $$
    BEGIN
      IF EXISTS(SELECT true FROM personal WHERE pers_krz=new.a1_krz) THEN
          Perform TSystem.Settings__Set('AdresseChangedByPersonal', 'T');
          UPDATE adk SET
            ad_str=pers_str,
            ad_plz=pers_plz,
            ad_ort=pers_ort,
            ad_landiso=pers_landiso,
            ad_land=pers_land,
            -- vgl. personal__a_iu_adresschange
            ad_tel2=CASE WHEN pers_tel2_f THEN pers_tel2 ELSE '***' END,
            ad_mobilpriv=CASE WHEN pers_mobilpriv_f THEN pers_mobilpriv ELSE '***' END
          FROM personal
          WHERE pers_krz=new.a1_krz
            AND ad_krz=pers_krz;
          Perform TSystem.Settings__Set('AdresseChangedByPersonal', 'F');
      END IF;
      RETURN new;
    END $$ LANGUAGE plpgsql;

     CREATE TRIGGER adk1__a_i_datenAusPersonal
      AFTER INSERT
      ON adk1
      FOR EACH ROW
      EXECUTE PROCEDURE adk1__a_i__datenAusPersonal();
  --

-- bei fehlenden Schreibrechten abbrechen
CREATE OR REPLACE FUNCTION adk1__b_iud__rights() RETURNS TRIGGER AS $$
  DECLARE a_knr integer;
  BEGIN
    IF tg_op='DELETE' THEN
        a_knr := old.a1_knr;
    ELSE
        a_knr := new.a1_knr;
    END IF;

    IF a_knr <> -1 THEN
    --#10029 a1_knr = -1 für alle erlauben
      IF
              EXISTS( SELECT * FROM pg_group WHERE groname = 'SYS.DebiKrediDat' )
          AND NOT user_in_group( current_user::varchar, 'SYS.DebiKrediDat' )
          AND ( TSystem.Settings__GetBool('adk1_adk2_knr__iu__ohne_SysDebiKrediDat_erlaubt' ) = false )
      THEN
          IF current_user::varchar NOT IN ( 'syncro', 'postgres' ) THEN
          -- #17703 Rechteprüfung entfällt für die beiden technischen User
              RAISE EXCEPTION 'xtt17180 (Group "SYS.DebiKrediDat")';  -- Zugriff verweigert. (Benutzerrechte)
          END IF;
      END IF;
    END IF;

    IF tg_op='DELETE' THEN
        RETURN old;
    ELSE
        RETURN new;
    END IF;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER adk1__b_iud__rights
    BEFORE INSERT OR UPDATE OR DELETE
    ON adk1
    FOR EACH ROW
    EXECUTE PROCEDURE adk1__b_iud__rights();

 --Verschlagwortung Adresssuche
 CREATE OR REPLACE FUNCTION adk1__a_90_iud_keywordsearch() RETURNS TRIGGER AS $$
  DECLARE krz varchar;
  BEGIN
   IF tg_op='DELETE' THEN
      krz:=old.a1_krz;
   ELSE
      krz:=new.a1_krz;
   END IF;
   PERFORM TSystem.kws_create_keywords(adk) FROM adk WHERE ad_krz=krz;
   RETURN new;
  END $$ LANGUAGE plpgsql;

 CREATE TRIGGER adk1__a_90_iud_keywordsearch
    AFTER INSERT OR UPDATE OR DELETE
    ON adk1
    FOR EACH ROW
    EXECUTE PROCEDURE adk1__a_90_iud_keywordsearch();

  --- #9675
 CREATE OR REPLACE FUNCTION adk1__a__i_a1_euexport() RETURNS TRIGGER AS $$
   BEGIN
     PERFORM TSystem.adk1__update__a1_euexport__a1_export(new.a1_krz);
     RETURN new;
   END $$ LANGUAGE plpgsql;

 CREATE TRIGGER adk1__a__i_a1_euexport
    AFTER INSERT
    ON adk1
    FOR EACH ROW
    EXECUTE PROCEDURE adk1__a__i_a1_euexport();

-- Abzuschläge
CREATE TABLE adk1abzu (                                                           -- VIEWFELDER
  a1z_id                serial NOT NULL PRIMARY KEY,                                --  ID des Zuschlags
  a1z_type              varchar(1)  DEFAULT 'P',                                    --  Zuschlagstyp, E-Einmalig, P-Position, M-Per ME
  a1z_pos               integer,                                                    --  Position
  a1z_abz_id            integer NOT NULL REFERENCES abzu,                           --  ID der Vorgabe
  a1z_krz               varchar(21) NOT NULL CONSTRAINT adk1abzu_ad_krz             --  ID des Datensatzes an dem der Zuschlag h�ngt
                             REFERENCES adk1 ON UPDATE CASCADE ON DELETE CASCADE,
  a1z_anz               numeric NOT NULL DEFAULT 1,                                 --  Anzahl / Menge
  a1z_betrag            numeric NOT NULL DEFAULT 0,                                 --  Betrag in W�hrung des Parent-Datensatzes
  a1z_proz              numeric,                                                    --  Prozentualer Zuschlag auf Basis des Parent-Betrags
  a1z_canskonto         boolean NOT NULL DEFAULT TRUE,                              --  Gilt Skonto f�r den Zuschlag?
  a1z_steucode           integer REFERENCES steutxt,                                 --  Steuercode (meist gleich Parent)
  a1z_steuproz          numeric(5,2),                                               --  Prozentsatz der Steuer
  a1z_konto             varchar(25),                                                --  Kontierung
  a1z_visible           boolean NOT NULL DEFAULT TRUE,                              --  Auf Dokument sichtbar oder nicht?
  a1z_zutxt             text,                                                       --  Zus�tzlicher Hinweistext
  a1z_zutxt_rtf         text,                                                       --  Zus�tzlicher Hinweistext (RTF)
  a1z_zutxt_int         text,                                                       --  Interner zusatztext (erscheint nicht auf Dokumenten)
  a1z_source_table      varchar(40),                                                --  Aus welcher Quelle wurde Abzu hierhin kopiert
  a1z_source_dbrid      varchar(32),                                                --  Aus welchem Datensatz wurde Abzu hierhin kopiert
  -- ZUSATZFELDER
  a1z_aknr              varchar(40)  -- Artikel bei dem dieser Abzuschlag gezogen wird
 );
--

-- Lieferantendaten
CREATE TABLE adk2
 (a2_krz                varchar(21) NOT NULL PRIMARY KEY REFERENCES adk ON UPDATE CASCADE ON DELETE CASCADE,
  a2_knr                integer NOT NULL,                                           -- Kreditorennummer
  a2_an1                varchar(15),
  a2_krl                numeric,
  a2_zak                smallint DEFAULT (TAdk.StandardZak('E')).zak,
  a2_skv                smallint NOT NULL DEFAULT (TAdk.StandardZak('E')).skv,
  a2_sks                numeric NOT NULL DEFAULT (TAdk.StandardZak('E')).sks,
  a2_maco               smallint,
  a2_spco               smallint NOT NULL DEFAULT 0 REFERENCES adkspco ON UPDATE CASCADE,
  a2_veco               varchar(10),
  a2_desk               varchar(12),
  a2_zera               varchar(15),
  a2_aprc               smallint,
  a2_bcnr               numeric,
  a2_bknr               varchar(50),
  a2_blz                varchar(30),
  a2_bank               varchar(60),
  a2_iban               varchar(50),
  a2_bic                varchar(50),
  a2_wuco               smallint DEFAULT TSystem.Settings__GetInteger('einksteucode', 9) REFERENCES steutxt,--vorsteuer 19%
  a2_dianeu             smallint,
  a2_dialog             smallint,
  a2_eknr               varchar(50),
  --a2_PALLG            numeric, --war rabatt beim lieferanten
  a2_allg1              varchar(20),
  a2_allg2              varchar(20),
  a2_waco               varchar(3) NOT NULL DEFAULT TSystem.Settings__Get('BASIS_W') REFERENCES bewa,
  a2_zahlart            smallint REFERENCES zahlart ON UPDATE CASCADE,
  a2_mbest              numeric,
  a2_norm               varchar(50),
  a2_zert              varchar(50),    --Zertifizierung Lieferant
  a2_zdat              date,           --Gültigkeitsdatum Zertifizierung Lieferant
  a2_uzert             varchar(50),    --Umweltzertifikat
  a2_uzdat             date,           --Gültigkeitsdatum Umweltzertifikat
  a2_bewe              varchar(50),    --Umfang der Zeritizierung
  a2_sperrkz           boolean NOT NULL DEFAULT FALSE, --Sperrkennzeichen äquivlent noz_sperr; später hinzugekommen, daher Name nicht gleich
  a2_bdat               date,
  a2_sperr              date,
  a2_autosperr          boolean NOT NULL DEFAULT FALSE, --zeigt in der Oberfläche, wenn der Lieferant durch das System gesperrt wurde (siehe Setting LiefSperren)
  a2_klass              varchar(1),
  a2_haupt              varchar(1),
  a2_deakt              date,
  a2_rabatt             numeric DEFAULT 0,
  a2_tolfrueh           integer,        -- Toleranz in Tagen bei Abweichung vom Lieferdatum (Zu früh)
  a2_tolspaet           integer,        -- Toleranz in Tagen bei Abweichung vom Lieferdatum (Zu spät)
  a2_toltext            text,           -- Ergänzungstext zu Lieferkonditionen
  a2_txt                text,           -- Ergänzungstext zu Kreditorendaten, Hinweistext zum Lieferant. Wird bei Anlage einer Bestellung angezeigt.
  a2_vers               varchar(50) DEFAULT (TAdk.StandardZak('E')).vers,       -- Versandart
  a2_minwert            numeric(12,4),  -- Mindestbestellwert
  a2_nda_dat            date,           -- Geheimhaltungsvertrag mit Lieferant hier erhalten
  a2_lsa_dat            date,           -- Lieferantenselbstauskunft an diesem Tag erhalten
  a2_lsa_datbis         date            -- Ablaufdatum der Lieferantenselbstauskunft
 );

CREATE INDEX adk2_a2_knr ON adk2 (a2_knr);

 --
 CREATE OR REPLACE FUNCTION adk2__b_10_iu__a2_knr() RETURNS TRIGGER AS $$
  DECLARE
      -- Systemvorgaben
      -- Setting: Adressverwaltung / Kreditoren von bzw. bis
      _min                  integer := TSystem.Settings__GetInteger( 'kredi_von' );
      _max                  integer := TSystem.Settings__GetInteger( 'kredi_bis' );
      -- Setting: Adressverwaltung / "Kreditorennummer kann mehrfach vorkommen" ist nicht gesetzt.
      _check_a2_knr_unique  boolean := NOT TSystem.Settings__GetBool( 'unique_a2_knr' );
  BEGIN
    -- Beachte:
      -- Negative Kreditorennummern sind zur initialen Anlage immer erlaubt.
      -- WHEN ( new.a2_knr > 0 )


    -- Prüfung des vorgebenen Bereichs der Kreditorennummern
    IF
            _min > 0
        AND _max > 0
        AND new.a2_knr NOT BETWEEN _min AND _max
    THEN

        RAISE EXCEPTION
            'xtt6240 - number (%) violates min (%) or max (%) of kredinummerkreis',
            new.a2_knr,
            _min,
            _max
        ;

    END IF;


    -- Prüfung auf doppelte Kreditorennummern
    IF
        -- gemäß Einstellung erforderlich
            _check_a2_knr_unique
        -- Es gibt gleiche Kreditorennummer an anderer Adresse.
        AND EXISTS(
              SELECT true
              FROM adk2
              WHERE a2_knr = new.a2_knr
                AND a2_krz <> new.a2_krz
            )
    THEN

        RAISE EXCEPTION 'duplicate key violates unique constraint "adk2_a2_knr" %', new.a2_knr;

    END IF;


    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER adk2__b_10_iu__a2_knr
    BEFORE INSERT OR UPDATE
    OF a2_knr
    ON adk2
    FOR EACH ROW
    -- Negative Kreditorennummern sind zur initialen Anlage immer erlaubt.
    WHEN ( new.a2_knr > 0 )
    EXECUTE PROCEDURE adk2__b_10_iu__a2_knr();
 --

 --
 CREATE OR REPLACE FUNCTION adk2__b_u_a2_sperr() RETURNS TRIGGER AS $$
  BEGIN
    -- Im Zusammenhang mit adk2_AutoSperrInaktiv()
    IF new.a2_sperr IS NULL AND new.a2_autosperr THEN
       new.a2_autosperr:=FALSE;
    END IF;
    RETURN new;
  END $$ LANGUAGE plpgsql;

 CREATE TRIGGER adk2__b_u_a2_sperr
   BEFORE UPDATE OF a2_sperr
   ON adk2
   FOR EACH ROW
   EXECUTE PROCEDURE adk2__b_u_a2_sperr();
 --

 -- Daten aus Personal ziehen, wenn Kreditor angelegt wird
 CREATE OR REPLACE FUNCTION adk2__a_i__datenAusPersonal() RETURNS TRIGGER AS $$
  BEGIN
    IF EXISTS(SELECT true FROM personal WHERE pers_krz=new.a2_krz) THEN
        Perform TSystem.Settings__Set('AdresseChangedByPersonal', 'T');
        UPDATE adk SET
          ad_str=pers_str,
          ad_plz=pers_plz,
          ad_ort=pers_ort,
          ad_landiso=pers_landiso,
          ad_land=pers_land,
          -- vgl. personal__a_iu_adresschange
          ad_tel2=CASE WHEN pers_tel2_f THEN pers_tel2 ELSE '***' END,
          ad_mobilpriv=CASE WHEN pers_mobilpriv_f THEN pers_mobilpriv ELSE '***' END
        FROM personal
        WHERE pers_krz=new.a2_krz
          AND ad_krz=pers_krz;
        Perform TSystem.Settings__Set('AdresseChangedByPersonal', 'F');
    END IF;
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER adk2__a_i_datenAusPersonal
    AFTER INSERT
    ON adk2
    FOR EACH ROW
    EXECUTE PROCEDURE adk2__a_i__datenAusPersonal();
 --
 CREATE OR REPLACE FUNCTION adk2__a_iu__a2_norm() RETURNS TRIGGER AS $$
  BEGIN
 IF tg_op='UPDATE' THEN
        IF old.a2_norm IS NOT NULL THEN --altes entfernen
                DELETE FROM normzert WHERE noz_ad_krz=new.a2_krz AND noz_iskred AND noz_qs_ident=old.a2_norm;
        END IF;
 END IF;
 --
    IF new.a2_norm IS NOT NULL THEN
        IF (SELECT qs_pnzt_type FROM qsnorm WHERE qs_ident=new.a2_norm) IS DISTINCT FROM 'FN' THEN -- Keine Fertigungsnorm für interne Norm angg.
            RAISE EXCEPTION '% %', lang_text(16324), E'\n\n'||lang_text(15433)||': '||new.a2_knr;
        END IF;
        INSERT INTO normzert(noz_ad_krz, noz_isdeb, noz_iskred, noz_qs_ident, noz_freig, noz_edat, noz_descr, noz_sperr)
           VALUES (new.a2_krz, false, true, new.a2_norm, new.a2_zert, new.a2_zdat, new.a2_bewe, new.a2_sperrkz);
 ELSE
        IF new.a2_zert IS NOT NULL OR new.a2_zdat IS NOT NULL OR new.a2_bewe IS NOT NULL OR new.a2_sperrkz THEN --wir haben im Block für die Norm eingaben hinsichtlich einer nicht eingegebenen Norm
                RAISE EXCEPTION '%', Format(lang_text(29190) /*'Ohne Norm kann keine Freigabeinformation der Norm vergeben werden. Zertifikate im unteren Block erfassen.'*/);
        END IF;
 END IF;
 --
 RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER adk2__a_iu__a2_norm
   AFTER INSERT OR UPDATE
   OF a2_norm, a2_zert, a2_zdat, a2_bewe, a2_sperrkz
   ON adk2
   FOR EACH ROW
   EXECUTE PROCEDURE adk2__a_iu__a2_norm();
 --
 --Verschlagwortung Adresssuche
 CREATE OR REPLACE FUNCTION adk2__a_90_iud_keywordsearch() RETURNS TRIGGER AS $$
  DECLARE krz varchar;
  BEGIN
   IF tg_op='DELETE' THEN
      krz:=old.a2_krz;
   ELSE
      krz:=new.a2_krz;
   END IF;
   PERFORM TSystem.kws_create_keywords(adk) FROM adk WHERE ad_krz=krz;
   RETURN new;
  END $$ LANGUAGE plpgsql;

   CREATE TRIGGER adk2__a_90_iud_keywordsearch
    AFTER INSERT OR UPDATE OR DELETE
    ON adk2
    FOR EACH ROW
    EXECUTE PROCEDURE adk2__a_90_iud_keywordsearch();

 -- Legt beim Insert die Default-Parameter für Lieferantenprüfung an
 CREATE TRIGGER adk2__a_i__create_autoparams
  AFTER INSERT
  ON adk2
  FOR EACH ROW
  EXECUTE PROCEDURE TRecnoParam.CreateAutoParams();
 -- bei fehlenden Schreibrechten abbrechen
 CREATE OR REPLACE FUNCTION adk2__b_iud__rights() RETURNS TRIGGER AS $$
  DECLARE a_knr integer;
  BEGIN
   IF tg_op='DELETE' THEN
      a_knr := old.a2_knr;
   ELSE
      a_knr := new.a2_knr;
   END IF;
   IF a_knr <> -1 THEN    --#10029 a2_knr = -1 für alle erlauben
      IF EXISTS(SELECT * FROM pg_group WHERE groname = 'SYS.DebiKrediDat') AND NOT user_in_group(current_user::varchar, 'SYS.DebiKrediDat') AND (TSystem.Settings__GetBool('adk1_adk2_knr__iu__ohne_SysDebiKrediDat_erlaubt') = false) THEN
         RAISE EXCEPTION 'SYS.DebiKrediDat AND Settings__GetBool(adk1_adk2_knr__iu__ohne_SysDebiKrediDat_erlaubt) = false xtt17180';  -- Zugriff verweigert. (Benutzerrechte)
      END IF;
   END IF;
   IF tg_op='DELETE' THEN
      RETURN old;
   ELSE
      RETURN new;
   END IF;
  END $$ LANGUAGE plpgsql;

 CREATE TRIGGER adk2__b_iud__rights
    BEFORE INSERT OR UPDATE OR DELETE
    ON adk2
    FOR EACH ROW
    -- #10029 Benutzer APPS und SYNCRO ausschliessen
    -- #19964 Benutzer postgres ausschliessen
    WHEN (current_user NOT IN ('APPS', 'SYNCRO', 'syncro', 'postgres'))
    EXECUTE PROCEDURE adk2__b_iud__rights();

-- APPS-Funktion zur automatischen Sperrung von Lieferanten nach x Monaten Inaktivität (keine Bestellungen erfasst)
CREATE OR REPLACE FUNCTION TADK.adk2__a2_autosperr__by__ldsdok() RETURNS VOID AS $$
 BEGIN
  IF TSystem.Settings__GetBool('LiefSperren') AND TSystem.Settings__GetInteger('monateLiefSperren') > 0 THEN -- Einstellungen: Einkauf
        UPDATE adk2 SET
          a2_sperr = current_date,
          a2_autosperr = TRUE
        WHERE
          (SELECT max(ld_datum) FROM ldsdok WHERE ld_kn = a2_krz) < current_date - TSystem.Settings__GetInteger('monateLiefSperren')*'1 month'::INTERVAL
          AND NOT a2_autosperr  -- nicht nochmal Datum setzen, wenn bereits gesetzt. 1. Sperrdatum aufheben
          AND a2_sperr IS NULL; -- keine Sperrung durch Anwender vorhanden
  END IF;
  RETURN;
 END $$ LANGUAGE plpgsql;
--
-- Mengenrabatte der Lieferanten
CREATE TABLE adk2rab
 (a2r_id                 serial NOT NULL PRIMARY KEY,
  a2r_krz                varchar(21) NOT NULL REFERENCES adk2 ON UPDATE CASCADE ON DELETE CASCADE, --Lieferantenkürzel
  a2r_betrag             numeric(12,2) NOT NULL, -- Betrag AB DEM der Rabatt gilt
  a2r_prozent            numeric(5,2) NOT NULL
  --,    -- Rabattumfang in Prozent
  --a2r_datv             date,
  --a2r_datb             date
 );

CREATE TABLE versart
 (v_id                  serial PRIMARY KEY,
  v_art                 varchar(75) UNIQUE,
  v_descr               varchar(100), --Beschreibung EXW: Standort des Werks (engl.: EX Works)
  v_stat                varchar(5),--L -> Versand durch Lieferant
  v_transportauftrag    boolean NOT NULL DEFAULT FALSE,
  v_ungueltig           boolean NOT NULL DEFAULT FALSE,  -- diese Versandart ist ungültig/gelöscht und kann nicht mehr verwendet werden (läßt sich aber eventuell nicht direkt löschen, da sie irgendwo verwendet wurde)
  v_adk_def             varchar(5),  -- als Vorgabe verwenden für E=Einkauf(adk2), V=Verkauf(adk1) oder EV=Einkauf+Verkauf
  v_zutxt               text            --Hinweistext
 );

CREATE UNIQUE INDEX versart_adkdef ON versart(UPPER(v_adk_def));  -- jeder Status kann nur maximal einmal vergeben sein

-- #7137 Versandarten Mehrsprachig
CREATE TABLE versarttxt
 (vl_id               serial NOT NULL PRIMARY KEY,
  vl_v_id             integer NOT NULL REFERENCES versart ON DELETE CASCADE,
  vl_spr_key          varchar(5) NOT NULL REFERENCES sprach,
  vl_txt              varchar(50)
 );

 CREATE OR REPLACE FUNCTION versart__a_iud() RETURNS TRIGGER AS $$
  BEGIN
    IF NOT tg_op='INSERT' THEN
        DELETE FROM versarttxt WHERE vl_v_id=old.v_id AND vl_spr_key=prodat_languages.current_lang();
    END IF;
    IF NOT tg_op='DELETE' THEN
        INSERT INTO versarttxt (vl_v_id, vl_spr_key, vl_txt) VALUES (new.v_id, prodat_languages.current_lang(), new.v_art);
    END IF;
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER versart__a_iud
   AFTER INSERT OR UPDATE OR DELETE
   ON versart
   FOR EACH ROW
   EXECUTE PROCEDURE versart__a_iud();

 -- Übersetzungsfunktion Versandarten in Externdokumenten
 CREATE OR REPLACE FUNCTION lang_versart(integer, varchar) RETURNS varchar AS $$    -- #7137
  DECLARE result varchar;
   BEGIN
     SELECT vl_txt INTO result FROM versarttxt WHERE vl_v_id=$1 AND vl_spr_key=$2;
     IF result IS NULL THEN
         SELECT vl_txt INTO result FROM versarttxt WHERE vl_v_id=$1 AND  vl_spr_key=prodat_languages.curr_lang();
     END IF;
   RETURN result;
  END $$ LANGUAGE plpgsql;

-- Adressname aus ad_fa1, ad_fa2, Nachname, Vorname (MIT Ort)
CREATE OR REPLACE FUNCTION adressebez(IN adkrz varchar) RETURNS varchar(200) AS $$
  DECLARE result varchar(200);
  BEGIN
    IF adkrz = '' THEN
        RETURN NULL;
    END IF;
    --caching
    SELECT c_resultc INTO result FROM tcache.function_cache WHERE c_funcname='adressebez' AND c_param0=adkrz AND NOT c_dirty;
    IF result IS NOT NULL THEN
        RETURN result;
    END IF;
    --end caching
    result:= coalesce(ad_fa1, '')       || coalesce(IFTHEN(coalesce(ad_fa1,'') = '', '', ', ') || ad_name, '')||
             coalesce(', '||ad_vorn, '')|| coalesce(', '||ad_str, '') || coalesce(', '||ad_plz, '') || coalesce(', '||ad_ort, '')
             FROM adressen_view WHERE ad_krz=adkrz;
    --caching schreiben
    PERFORM tcache.function_cache_setcache_1param('adressebez', adkrz, NULL, result);
    --end caching schreiben
    RETURN result;
  END $$ LANGUAGE plpgsql STABLE STRICT;
--

-- Adressname aus ad_fa1, ad_fa2, Nachname, Vorname (OHNE Ort)
-- http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Adk
CREATE OR REPLACE FUNCTION adressename(IN adkrz varchar) RETURNS varchar(200) AS $$
  DECLARE adfa1 varchar;
          adfa2 varchar;
          adname varchar;
          advorn varchar;
          result varchar(200);
  BEGIN
    IF adkrz = '' THEN
        RETURN NULL;
    END IF;
    --caching
    SELECT c_resultc INTO result FROM tcache.function_cache WHERE c_funcname='adressename' AND c_param0=adkrz AND NOT c_dirty;
    IF result IS NOT NULL THEN
        RETURN result;
    END IF;
    --end caching
    SELECT ad_fa1, ad_fa2, ad_name, ad_vorn INTO adfa1, adfa2, adname, advorn FROM adressen_view WHERE ad_krz=adkrz;
    result:=coalesce(adfa1,'') || IfThen(LTRIM(coalesce(adfa2,'')) = '', '', ', '|| coalesce(adfa2,''));

    IF (adfa1 IS NULL) OR (adfa1 = '') THEN
        result:= coalesce(adname,'');
    ELSE
        result:= result||IfThen(LTRIM(coalesce(adname,'')) = '','', ' - ') || coalesce(adname,'');
    END IF;
    --
    IF (advorn IS NOT NULL) AND (advorn <> '') THEN
        result:= result || ', ' || advorn;
    END IF;
    --caching schreiben
    PERFORM tcache.function_cache_setcache_1param('adressename', adkrz, NULL, result);
    --end caching schreiben
    RETURN result;
  END $$ LANGUAGE plpgsql STABLE STRICT;
--

-- http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Adk
CREATE OR REPLACE FUNCTION adresse_apname(IN apid integer, adkrz varchar DEFAULT NULL, apkrz varchar DEFAULT NULL, FullDescription boolean DEFAULT True) RETURNS varchar(200) AS $$
DECLARE _apid varchar;
        S varchar;
        AP varchar;
        result varchar;
BEGIN
 IF apid IS NOT NULL THEN
        _apid:=apid;
 ELSE
        _apid:=ap_id FROM adkap WHERE ap_ad_krz=adkrz AND ap_krzl=apkrz;
 END IF;
 --
 --Sicherung ap:=CAST(Trim(IFTHEN(FullDescription, Trim(coalesce(ap_anr, '')||' '||coalesce(ap_titel,''))||' ', '') || coalesce(ap_vorn,'')||' '||coalesce(ap_name,'')) AS varchar(100))
 ap:=CAST(Trim(
 CASE WHEN FullDescription Then -- Anrede(abweichend) danach Standardanrede Herr/Frau
   Trim(coalesce(ap_anr, CASE WHEN ap_sex_man IS NOT NULL THEN IFTHEN(ap_sex_man, lang_text(25179,coalesce(a1_spco, a2_spco)), lang_text(26007,coalesce(a1_spco, a2_spco))) END, '')
   ||' '||coalesce(ap_titel,''))||' '
 ELSE '' END
 || coalesce(ap_vorn,'')||' '||coalesce(ap_name,'')) AS varchar(100))
 FROM
  adkap
  LEFT JOIN adk1 ON a1_krz=ap_ad_krz
  LEFT JOIN adk2 ON a2_krz=ap_ad_krz
 WHERE
  ap_id=_apid;
 --
 IF ap IS NULL THEN
        result:=ad_vorn||' '||ad_name FROM adk WHERE ad_krz=adkrz; --adresseName(adkrz);
 ELSE
        result:=ap;
 END IF;
 If ap IS NOT NULL AND FullDescription AND adkrz IS NOT NULL THEN --der Ansprechpartner wurde nicht direkt angegeben, daher nehmen wir die Firma noch dazu
        S:=ad_fa1 FROM adk WHERE ad_krz=adkrz;
        result:=coalesce(S||': ', '')||ap;
 END IF;
 --
 RETURN result;
END $$ LANGUAGE plpgsql STABLE;

-- http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Adk
CREATE OR REPLACE FUNCTION adresse_apMail(IN adkrz varchar, IN apkrzlORadresseApName varchar) RETURNS varchar(50) AS $$
DECLARE mail varchar;
BEGIN
  SELECT ap_mail INTO mail FROM adkap
        WHERE ap_ad_krz = adkrz
              AND (
                    TRIM(ap_krzl) = TRIM(apkrzlORadresseApName)
                   OR
                    TRIM(adresse_apname(ap_id)) = TRIM(apkrzlORadresseApName)
                   )
                   LIMIT 1;
  IF TRIM(coalesce(mail,'')) = '' THEN
    SELECT ad_email1 INTO mail FROM adk WHERE ad_krz = adkrz LIMIT 1;
  END IF;
  RETURN mail;
END $$ LANGUAGE plpgsql STABLE;


CREATE OR REPLACE FUNCTION tadk.normzert__zert__gueltig__check( _noz_id integer ) RETURNS boolean AS $$

      -- Ticket https://redmine.prodat-sql.de/issues/15974
      --   prüft ob ein bestimmtes Zertifikat zum jetzigen Zeitpunkt gültig ist
      SELECT
        coalesce(
                noz_apint IS NOT null
            AND noz_edat >= current_date,
            false
        )
      FROM normzert
      WHERE noz_id = _noz_id;
  $$ LANGUAGE sql;
--


-- keine leeren Statements am Ende vom Erstellen der DB erlaubt.
SELECT TRUE;
